/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.resource;

import dev.vankka.dependencydownload.dependency.Dependency;
import dev.vankka.dependencydownload.dependency.SnapshotDependency;
import dev.vankka.dependencydownload.dependency.StandardDependency;
import dev.vankka.dependencydownload.relocation.Relocation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DependencyDownloadResource {
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final List<Relocation> relocations = new ArrayList<Relocation>();

    public DependencyDownloadResource(@NotNull URL resourceURL) throws IOException {
        List<String> lines;
        try (InputStream inputStream = resourceURL.openStream();){
            lines = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.toList());
        }
        this.readFile(lines);
    }

    public DependencyDownloadResource(@NotNull String resourceContents) {
        this.readFile(Arrays.asList(resourceContents.split("\n")));
    }

    public DependencyDownloadResource(@NotNull List<String> resourceLines) {
        this.readFile(resourceLines);
    }

    private void readFile(List<String> lines) {
        String hashingAlgorithm = null;
        int relocationStep = -1;
        String pattern = null;
        String replacement = null;
        Set<String> include = null;
        block5: for (String line : lines) {
            String classifier;
            String snapshotTimestamp;
            if ((line = line.trim()).isEmpty()) continue;
            if (line.startsWith("===ALGORITHM")) {
                String[] algorithmParts = line.split(" ");
                if (algorithmParts.length != 2) {
                    throw new IllegalArgumentException("Resource format is invalid: hashing algorithm: " + line);
                }
                hashingAlgorithm = algorithmParts[1];
                continue;
            }
            if (hashingAlgorithm == null) {
                throw new IllegalArgumentException("Resource format is invalid: no hashing algorithm");
            }
            if (line.startsWith("===RELOCATIONS") && relocationStep == -1) {
                relocationStep = 0;
                continue;
            }
            if (relocationStep != -1) {
                switch (relocationStep) {
                    case 0: {
                        pattern = line;
                        break;
                    }
                    case 1: {
                        replacement = line;
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (!line.startsWith("[") || !line.endsWith("]")) {
                            throw new IllegalArgumentException("Resource format is invalid: expecting a includes/excludes: " + line);
                        }
                        Set<String> values = !(line = line.substring(1, line.length() - 1)).trim().isEmpty() ? new HashSet<String>(Arrays.asList(line.split(","))) : Collections.emptySet();
                        if (relocationStep == 2) {
                            include = values;
                            break;
                        }
                        if (replacement == null) {
                            throw new IllegalStateException("Replacement may not be null");
                        }
                        this.relocations.add(new Relocation(pattern, replacement, include, values));
                        include = null;
                        relocationStep = 0;
                        continue block5;
                    }
                }
                ++relocationStep;
                continue;
            }
            String[] parts = line.split(" ");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Resource format is invalid: invalid dependency: " + line);
            }
            String maven = parts[0];
            String hash = parts[1];
            String[] mavenParts = maven.split(":");
            int partCount = mavenParts.length;
            if (partCount < 3 || partCount > 5) {
                throw new IllegalArgumentException("Resource format is invalid: invalid dependency GAV: " + maven + " (" + partCount + ")");
            }
            String group = mavenParts[0];
            String artifact = mavenParts[1];
            String version = mavenParts[2];
            if (version.endsWith("-SNAPSHOT")) {
                snapshotTimestamp = mavenParts[3];
                classifier = partCount == 5 ? mavenParts[4] : null;
            } else {
                snapshotTimestamp = null;
                classifier = partCount == 4 ? mavenParts[3] : null;
            }
            StandardDependency dependency = snapshotTimestamp == null ? new StandardDependency(group, artifact, version, classifier, hash, hashingAlgorithm) : new SnapshotDependency(group, artifact, version, classifier, snapshotTimestamp, hash, hashingAlgorithm);
            this.dependencies.add(dependency);
        }
        if (relocationStep > 1) {
            this.relocations.add(new Relocation(pattern, replacement, include, null));
        }
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<Relocation> getRelocations() {
        return this.relocations;
    }
}

